package org.dalinium.webtest.blog;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class Blog {
	private static Blog instance;
	static {
		instance = new Blog();
	}
	
	public static Blog getInstance() {
		return instance;
	}
	
	//=======================================================================//
	
	private Map<String, BlogMessage> messages;
	
	public Blog() {
		messages = new TreeMap<String, BlogMessage>();
	}
	
	public Collection<BlogMessage> getMessages() {
		return messages.values();
	}
	
	public BlogMessage getMessage(String id) {
		return messages.get(id);
	}
	
	public void addMessage(BlogMessage message) {
		messages.put(message.getId(), message);
	}
	
	public void deleteMessage(String id) {
		messages.remove(id);
	}
}
