package org.dalinium.webtest.blog;

import java.util.Date;

public class BlogComment {
	private static int lastId = 0;
	
	private String id;
	private String content;
	private String author;
	private Date date;
	private int scoreTotal;
	private int scoreCount;
	
	public BlogComment(String content, String author) {
		this.id = Integer.toString(lastId++);
		this.content = content;
		this.author = author;
		this.date = new Date();
		this.scoreTotal = 0;
		this.scoreCount = 0;
	}
	
	public String getId() {
		return id;
	}
	
	public String getContent() {
		return content;
	}
	
	public String getAuthor() {
		return author;
	}
	
	public Date getDate() {
		return date;
	}
	
	public void rate(int score) {
		scoreTotal += score;
		scoreCount++;
	}
	
	public double getScore() {
		return (double) scoreTotal / (double) scoreCount;
	}
}
