package org.dalinium.webtest.blog;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BlogMessage implements Comparable<BlogMessage> {
	private static int lastId = 0;
	
	private String id;
	private String content;
	private String author;
	private Date date;
	private Map<String, BlogComment> comments;
	
	public BlogMessage(String content, String author) {
		this.id = Integer.toString(lastId++);
		this.content = content;
		this.author = author;
		this.date = new Date();
		this.comments = new HashMap<String, BlogComment>();
	}
	
	public int compareTo(BlogMessage o) {
		if (id.equals(o.id)) {
			return 0;
		}
		
		return date.compareTo(o.date);
	}
	
	public String getId() {
		return id;
	}
	
	public String getContent() {
		return content;
	}
	
	public String getAuthor() {
		return author;
	}
	
	public Collection<BlogComment> getComments() {
		return comments.values();
	}
	
	public BlogComment getComment(String id) {
		return comments.get(id);
	}
	
	public void addComment(BlogComment comment) {
		comments.put(comment.getId(), comment);
	}
}
