package org.dalinium.webtest.blog.webflow;

import org.dalinium.webflow.engine.TransitionContext;
import org.dalinium.webflow.instance.WebFlow;
import org.dalinium.webflow.instance.WebFlowPeer;
import org.dalinium.webflow.servlet.renderer.WebFlowAjaxJavascriptEvalRenderer;
import org.dalinium.webflow.servlet.renderer.WebFlowAjaxUpdateRenderer;
import org.dalinium.webtest.blog.Blog;
import org.dalinium.webtest.blog.BlogComment;
import org.dalinium.webtest.blog.BlogMessage;

public class BlogPeer implements WebFlowPeer {
	private WebFlow webFlow;
	public String selectedMessage;
	
	public BlogPeer() {
		selectedMessage = null;
	}
	
	public WebFlowPeer clonePeer() {
		try {
			BlogPeer clone = new BlogPeer();
			clone.selectedMessage = selectedMessage;
			
			return clone;
		}
		catch (Exception e) {
			throw new RuntimeException("Cannot clone AbstractBlogPeer", e);
		}
	}
	
	public void initialize(TransitionContext context) {
		webFlow = context.getWebFlow();
		
		context.setResultState("public");
	}
	
	public String getSelectedMessage() {
		return selectedMessage;
	}
	
	public void viewMessage(TransitionContext context) {
		selectedMessage = context.getRequest().getParameterValue("id");
	}
	
	public void backToMessages(TransitionContext context) {
		selectedMessage = null;
	}
	
	public void login(TransitionContext context) {
		String login = context.getRequest().getParameterValue("login");
		String password = context.getRequest().getParameterValue("password");
		if (login.equals("user") && password.equals("pass")) {
			webFlow.addPermission("permission.admin");
		}
		else {
			context.setResponseRenderer(new WebFlowAjaxJavascriptEvalRenderer("/scripts/ajax/loginFailure.js", true));
		}
	}
	
	public void logoff(TransitionContext context) {
		webFlow.removePerssion("permission.admin");
	}
	
	public void postMessage(TransitionContext context) {
		String content = context.getRequest().getParameterValue("content");
		String author = context.getRequest().getParameterValue("author");
		
		BlogMessage message = new BlogMessage(content, author);
		Blog.getInstance().addMessage(message);
		
		context.setResponseRenderer(new WebFlowAjaxUpdateRenderer("messages", "/ViewBlogMessages.do", true));
	}
	
	public void deleteMessage(TransitionContext context) {
		if (selectedMessage != null) {
			Blog.getInstance().deleteMessage(selectedMessage);
		}
		else {
			String id = context.getRequest().getParameterValue("id");
			Blog.getInstance().deleteMessage(id);
		}
		
		context.setResponseRenderer(new WebFlowAjaxUpdateRenderer("messages", "/ViewBlogMessages.do", true));
	}
	
	public void postComment(TransitionContext context) {
		String content = context.getRequest().getParameterValue("content");
		String author = context.getRequest().getParameterValue("author");
		
		BlogComment comment = new BlogComment(content, author);
		Blog.getInstance().getMessage(selectedMessage).addComment(comment);
		
		context.setResponseRenderer(new WebFlowAjaxUpdateRenderer("comments", "/ViewMessageComments.do", true));
	}
	
	public void rateComment(TransitionContext context) {
		int score = Integer.parseInt(context.getRequest().getParameterValue("score"));
		
		String selectedComment = context.getRequest().getParameterValue("id");
		Blog.getInstance().getMessage(selectedMessage).getComment(selectedComment).rate(score);
	}
}
