/*
 * Decompiled with CFR 0.152.
 */
package org.dalinium.webtest.blog;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dalinium.webtest.blog.BlogComment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogMessage
implements Comparable<BlogMessage> {
    private static int lastId = 0;
    private String id = Integer.toString(lastId++);
    private String content;
    private String author;
    private Date date;
    private Map<String, BlogComment> comments;

    public BlogMessage(String content, String author) {
        this.content = content;
        this.author = author;
        this.date = new Date();
        this.comments = new HashMap();
    }

    @Override
    public int compareTo(BlogMessage o) {
        if (this.id.equals(o.id)) {
            return 0;
        }
        return this.date.compareTo(o.date);
    }

    public String getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public String getAuthor() {
        return this.author;
    }

    public Collection<BlogComment> getComments() {
        return this.comments.values();
    }

    public BlogComment getComment(String id) {
        return (BlogComment)this.comments.get(id);
    }

    public void addComment(BlogComment comment) {
        this.comments.put(comment.getId(), comment);
    }
}

