/*
 * Decompiled with CFR 0.152.
 */
package org.dalinium.webtest.blog.webflow;

import org.dalinium.webflow.engine.TransitionContext;
import org.dalinium.webflow.instance.WebFlow;
import org.dalinium.webflow.instance.WebFlowPeer;
import org.dalinium.webflow.servlet.renderer.WebFlowAjaxJavascriptEvalRenderer;
import org.dalinium.webflow.servlet.renderer.WebFlowAjaxRenderer;
import org.dalinium.webflow.servlet.renderer.WebFlowAjaxUpdateRenderer;
import org.dalinium.webtest.blog.Blog;
import org.dalinium.webtest.blog.BlogComment;
import org.dalinium.webtest.blog.BlogMessage;

public class BlogPeer
implements WebFlowPeer {
    private WebFlow webFlow;
    public String selectedMessage = null;

    public WebFlowPeer clonePeer() {
        try {
            BlogPeer clone = new BlogPeer();
            clone.selectedMessage = this.selectedMessage;
            return clone;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot clone AbstractBlogPeer", e);
        }
    }

    public void initialize(TransitionContext context) {
        this.webFlow = context.getWebFlow();
        context.setResultState("public");
    }

    public String getSelectedMessage() {
        return this.selectedMessage;
    }

    public void viewMessage(TransitionContext context) {
        this.selectedMessage = context.getRequest().getParameterValue("id");
    }

    public void backToMessages(TransitionContext context) {
        this.selectedMessage = null;
    }

    public void login(TransitionContext context) {
        String login = context.getRequest().getParameterValue("login");
        String password = context.getRequest().getParameterValue("password");
        if (login.equals("user") && password.equals("pass")) {
            this.webFlow.addPermission("permission.admin");
        } else {
            context.setResponseRenderer((WebFlowAjaxRenderer)new WebFlowAjaxJavascriptEvalRenderer("/scripts/ajax/loginFailure.js", true));
        }
    }

    public void logoff(TransitionContext context) {
        this.webFlow.removePerssion("permission.admin");
    }

    public void postMessage(TransitionContext context) {
        String content = context.getRequest().getParameterValue("content");
        String author = context.getRequest().getParameterValue("author");
        BlogMessage message = new BlogMessage(content, author);
        Blog.getInstance().addMessage(message);
        context.setResponseRenderer((WebFlowAjaxRenderer)new WebFlowAjaxUpdateRenderer("messages", "/ViewBlogMessages.do", true));
    }

    public void deleteMessage(TransitionContext context) {
        if (this.selectedMessage != null) {
            Blog.getInstance().deleteMessage(this.selectedMessage);
        } else {
            String id = context.getRequest().getParameterValue("id");
            Blog.getInstance().deleteMessage(id);
        }
        context.setResponseRenderer((WebFlowAjaxRenderer)new WebFlowAjaxUpdateRenderer("messages", "/ViewBlogMessages.do", true));
    }

    public void postComment(TransitionContext context) {
        String content = context.getRequest().getParameterValue("content");
        String author = context.getRequest().getParameterValue("author");
        BlogComment comment = new BlogComment(content, author);
        Blog.getInstance().getMessage(this.selectedMessage).addComment(comment);
        context.setResponseRenderer((WebFlowAjaxRenderer)new WebFlowAjaxUpdateRenderer("comments", "/ViewMessageComments.do", true));
    }

    public void rateComment(TransitionContext context) {
        int score = Integer.parseInt(context.getRequest().getParameterValue("score"));
        String selectedComment = context.getRequest().getParameterValue("id");
        Blog.getInstance().getMessage(this.selectedMessage).getComment(selectedComment).rate(score);
    }
}

