
var webFlow = new Object();
webFlow.request = new Object();
webFlow.engine = new Object();

//===== HTTP request ========================================================//

webFlow.request.http = function(url, handler) {
	this.url = url;
	this.handler = handler;
}

webFlow.request.http.prototype.send = function(data) {
	if ( window.XMLHttpRequest ) {
		this.request = new XMLHttpRequest();
	}
	else { // IE
		this.request = new ActiveXObject("MSXML2.XMLHTTP");
	}
	
	var self = this;
	this.request.onreadystatechange = function() {
		self.update();
	}
	
	this.request.open("POST", this.url, true);
	this.request.setRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
    	this.request.setRequestHeader("Content-length", data.length);
	this.request.send(data);
}

webFlow.request.http.prototype.update = function() {
	if (this.request.readyState == 4) {
		if (this.request.status != 200) {
			alert('An error occured on the server');
		}
		
		this.handler.handle(this);
	}
}

webFlow.request.http.prototype.responseAsXml = function() {
	return this.request.responseXML;
}



//===== Transition request ==================================================//

webFlow.request.transition = function(handlerFunction, webFlowId, transitionId, data) {
	this.handlerFunction = handlerFunction;
	this.webFlowId = webFlowId;
	this.transitionId = transitionId;
	this.data = data;
}

webFlow.request.transition.prototype.send = function() {
	new webFlow.request.http(document.location.href, this).send("ajax=true&webFlowId=" + this.webFlowId + "&transitionId=" + this.transitionId + "&" + this.data);
}

webFlow.request.transition.prototype.handle = function(httpRequest) {
	var response = getChildNode(httpRequest.responseAsXml(), 'response');
	
	var code = getChildNode(response, 'code');
	var content = getChildNode(response, 'content');
	
	this.handlerFunction.call(undefined, code, content);
}



//===== Transition engine ===================================================//

webFlow.engine.doTransition = function(webFlowId, transitionId, parameters) {
	var transition = new webFlow.request.transition(webFlow.engine.handleTransitionResponse, webFlowId, transitionId, parameters);
	transition.send();
}

webFlow.engine.handleTransitionResponse = function(code, content) {
	var codeAsText = getNodeValue(code);
	
	if ("javascript" == codeAsText) {
		var contentAsText = getNodeValue(content);
		eval(contentAsText);
	}
	else if ("update" == codeAsText) {
		var id = getChildNode(content, 'id');
		var idAsText = getNodeValue(id);
		
		var value = getChildNode(content, 'value');
		var valueAsText = getNodeValue(value);
		
		var element = document.getElementById(idAsText);
		if (element != undefined) {
			element.innerHTML = valueAsText;
		}
	}
	else if ("composite" == codeAsText) {
		var components = getChildrenNodes(composite, 'component');
		for (var i = 0;i < components.length;i++) {
			var component = components[i];
			
			var code = getChildNode(component, 'code');
			var content = getChildNode(component, 'content');
			
			webFlow.engine.handleTransitionResponse(code, content);
		}
	}
	else {
		alert("Unknown code: '" + codeAsText + "'");
	}
}



//===== Utils ===============================================================//

function getChildrenNodes(object, name) {
	return object.getElementsByTagName(name);
}

function getChildNode(object, name) {
	return object.getElementsByTagName(name)[0];
}

function getChildNodeValue(object, name) {
	return getChildNode(object, name).firstChild.nodeValue; 
}

function getNodeValue(object) {
	if (object == null || object == undefined) {
		return null;
	}
	
	var firstChild = object.firstChild;
	if (firstChild == null || firstChild == undefined) {
		return null;
	}
	
	return firstChild.nodeValue;
}



//===== Business functions ==================================================//

function submitWebFlowForm(form, webFlowId, transitionId) {
	var parameters = "";
	for (var i = 0;i < form.elements.length;i++) {
		var element = form.elements[i];
		
		var name = element.name;
		var value = element.value;
		
		if (name == 'transitionId') {
			alert('transitionId is set multiple times');
		}
		
		switch (element.type) {
			case "text":
			case "hidden":
			case "password":
			case "textarea":
				parameters += name + "=" + value + "&";
				break;
				
			case "checkbox":
			case "radio":
				if (element.checked) {
					parameters += name + "=" + value + "&";
				}
				break;
				
			case "select-one":
				parameters += name + "=" + element.options[element.selectedIndex].value + "&";
				break;
		}
	}
	
	if (parameters.length > 0) {
		parameters = parameters.substr(0, (parameters.length - 1))
	}
	
	webFlow.engine.doTransition(webFlowId, transitionId, parameters);
}

function submitWebFlowLink(webFlowId, transitionId, parameters) {
	webFlow.engine.doTransition(webFlowId, transitionId, parameters);
}